function [psicf,psicdif,phif,phidif,thetaf,thetadif,thetaratio,thetaoddsratio]=...
    reproduceparam5(nuoflevelst,vectorofxt,averageyt,averagext,clusterallocfinal,clusteralloctemp,riskthetatemp,psictemp,phitemp,itertemp,maxnumofclustemp,refgroupforor)

% THIS FUNCTION REPRODUCES THE PARAMETERS PSI, PHI, THETA AFTER A FINAL
% CLUSTERING HAS BEEN SELECTED
% clusterallocfinal is the finally selected clustering.
% clusteralloctemp is the saved cluster allocations 

psicf=zeros(itertemp,maxnumofclustemp);
psicdif=zeros(itertemp,maxnumofclustemp);
thetaf=zeros(itertemp,maxnumofclustemp);
thetadif=zeros(itertemp,maxnumofclustemp);
thetaratio=zeros(itertemp,maxnumofclustemp);
thetaoddsratio=zeros(itertemp,maxnumofclustemp);
phif=zeros(itertemp,size([phitemp{1,1,:}],2),maxnumofclustemp);
phidif=zeros(itertemp,size([phitemp{1,1,:}],2),maxnumofclustemp);
gooddispphi0=cell(1,maxnumofclustemp);
gooddispphi=cell(1,maxnumofclustemp);
gooddispphi2=cell(1,maxnumofclustemp);

funcaverage=@mean;
funcaverage2=@mean;

for i=1:itertemp
   for icluster=1:maxnumofclustemp % this refers to the clusters of the final clustering
       if sum(clusterallocfinal==icluster)>0
        psicf(i,icluster)=mean(psictemp(i,clusteralloctemp(i,clusterallocfinal==icluster)));
        psicdif(i,icluster)=mean(psictemp(i,clusteralloctemp(i,clusterallocfinal==icluster)))...
            -mean(psictemp(i,clusteralloctemp(i,:)));
        thetaf(i,icluster)=funcaverage(riskthetatemp(i,clusteralloctemp(i,clusterallocfinal==icluster)));
        thetadif(i,icluster)=thetaf(i,icluster)-funcaverage(riskthetatemp(i,clusteralloctemp(i,:)));
        thetaratio(i,icluster)=thetaf(i,icluster)/funcaverage(riskthetatemp(i,clusteralloctemp(i,:)));     
        thetafrefgroup=funcaverage(riskthetatemp(i,clusteralloctemp(i,clusterallocfinal==refgroupforor)));
        thetaoddsratio(i,icluster)=(thetaf(i,icluster)/(1-thetaf(i,icluster)))/(thetafrefgroup/(1-thetafrefgroup));  
        phitemp2=zeros(1,size([phitemp{1,icluster,:}],2));
        phitemp2mean=zeros(1,size([phitemp{1,icluster,:}],2));
        for icluster2=1:maxnumofclustemp % this for the clusters in each iteration
            phitemp1=[phitemp{i,icluster2,:}]; % creates a vector with the elements of phisave{itemp,ictemp,:}
            phitemp2=phitemp2+sum(clusteralloctemp(i,clusterallocfinal==icluster)==icluster2)*phitemp1;
            phitemp2mean=phitemp2mean+sum(clusteralloctemp(i,:)==icluster2)*phitemp1;
        end
        phif(i,:,icluster)=phitemp2/sum(clusterallocfinal==icluster);
        phidif(i,:,icluster)=(phitemp2/sum(clusterallocfinal==icluster))...
            -(phitemp2mean/size(clusterallocfinal,2));
       end
   end
end

% *********************************************************************
% This is for displaying the actual densities and CIs of the parameters
% and their significance w.r.t. the population averages
% *********************************************************************
% *********************************************************************
% This is for the density of the difference between a theta or phi and
%         the average of the corresponding phi ot theta in the iteration
% *********************************************************************

for icluster=1:maxnumofclustemp %calculations and rough display of phis
    gooddispphi0{icluster}='';
    if sum(clusterallocfinal==icluster)>1
    dispphi=funcaverage2(phif(:,:,icluster),1); 
    disp(['Av. phis for cl. ' num2str(icluster) ' = ' num2str(dispphi)]); 
    disp('CIs:')
    for iii=1:size(phitemp2,2)
        tempsortphi=sort(phif(:,iii,icluster)); % for the CI's
        if averagext(iii)<tempsortphi(round(itertemp*2.5/100))
        gooddispphi0{icluster}=[gooddispphi0{icluster} '>'];
        disp([' (' num2str(tempsortphi(round(itertemp*2.5/100))) ',' num2str(tempsortphi(round(itertemp*97.5/100))) ') **>'])
        elseif averagext(iii)>tempsortphi(round(itertemp*97.5/100))
        gooddispphi0{icluster}=[gooddispphi0{icluster} '<'];
        disp([' (' num2str(tempsortphi(round(itertemp*2.5/100))) ',' num2str(tempsortphi(round(itertemp*97.5/100))) ') **<'])
        else
        gooddispphi0{icluster}=[gooddispphi0{icluster} '0'];
        disp([' (' num2str(tempsortphi(round(itertemp*2.5/100))) ',' num2str(tempsortphi(round(itertemp*97.5/100))) ') '])
        end
    end
    end
end

for icluster=1:maxnumofclustemp %calculations and rough display for differences of phis
    gooddispphi{icluster}='';
    if sum(clusterallocfinal==icluster)>1
    dispphi=funcaverage2(phidif(:,:,icluster),1); 
    disp(['Av. phidifs for cl. ' num2str(icluster) ' = ' num2str(dispphi)]); 
    disp('CIs:')
    for iii=1:size(phitemp2,2)
        tempsortphi=sort(phidif(:,iii,icluster)); % for the CI's
        if 0<tempsortphi(round(itertemp*2.5/100))
        gooddispphi{icluster}=[gooddispphi{icluster} '>'];
        disp([' (' num2str(tempsortphi(round(itertemp*2.5/100))) ',' num2str(tempsortphi(round(itertemp*97.5/100))) ') **>'])
        elseif 0>tempsortphi(round(itertemp*97.5/100))
        gooddispphi{icluster}=[gooddispphi{icluster} '<'];
        disp([' (' num2str(tempsortphi(round(itertemp*2.5/100))) ',' num2str(tempsortphi(round(itertemp*97.5/100))) ') **<'])
        else
        gooddispphi{icluster}=[gooddispphi{icluster} '0'];
        disp([' (' num2str(tempsortphi(round(itertemp*2.5/100))) ',' num2str(tempsortphi(round(itertemp*97.5/100))) ') '])
        end
    end
    end
end

for icluster=1:maxnumofclustemp % for displaying cluster info
    if sum(clusterallocfinal==icluster)>1
    tempsorttheta=sort(thetaf(:,icluster));
    tempsortthetadiff=sort(thetadif(:,icluster));
    tempsortthetaratio=sort(thetaratio(:,icluster));
    tempsortthetaoddsratio=sort(thetaoddsratio(:,icluster));
    if averageyt<tempsorttheta(round(itertemp*2.5/100)) 
    disp(['Average risk for cluster ' num2str(icluster) ' = ' num2str(funcaverage(thetaf(:,icluster)))...
        ' CI = (' num2str(tempsorttheta(round(itertemp*2.5/100))) ',' num2str(tempsorttheta(round(itertemp*97.5/100)))...
        '), No of subj.=' num2str(sum(clusterallocfinal==icluster)) ' **>  ' gooddispphi0{icluster}]);
    elseif averageyt>tempsorttheta(round(itertemp*97.5/100))
    disp(['Average risk for cluster ' num2str(icluster) ' = ' num2str(funcaverage(thetaf(:,icluster)))...
        ' CI = (' num2str(tempsorttheta(round(itertemp*2.5/100))) ',' num2str(tempsorttheta(round(itertemp*97.5/100)))...
        '), No of subj.=' num2str(sum(clusterallocfinal==icluster)) ' **<  ' gooddispphi0{icluster}]);
    else
    disp(['Average risk for cluster ' num2str(icluster) ' = ' num2str(funcaverage(thetaf(:,icluster)))...
        ' CI = (' num2str(tempsorttheta(round(itertemp*2.5/100))) ',' num2str(tempsorttheta(round(itertemp*97.5/100)))...
        '), No of subj.=' num2str(sum(clusterallocfinal==icluster)) '    ' gooddispphi0{icluster}]);
    end
    if 0<tempsortthetadiff(round(itertemp*2.5/100)) 
    disp(['Average riskdiff for cluster ' num2str(icluster) ' = ' num2str(funcaverage(thetadif(:,icluster)))...
        ' CI = (' num2str(tempsortthetadiff(round(itertemp*2.5/100))) ',' num2str(tempsortthetadiff(round(itertemp*97.5/100)))...
        '), No of subj.=' num2str(sum(clusterallocfinal==icluster)) ' **>  ' gooddispphi{icluster}]);
    elseif 0>tempsortthetadiff(round(itertemp*97.5/100))
    disp(['Average riskdiff for cluster ' num2str(icluster) ' = ' num2str(funcaverage(thetadif(:,icluster)))...
        ' CI = (' num2str(tempsortthetadiff(round(itertemp*2.5/100))) ',' num2str(tempsortthetadiff(round(itertemp*97.5/100)))...
        '), No of subj.=' num2str(sum(clusterallocfinal==icluster)) ' **<  ' gooddispphi{icluster}]);
    else
    disp(['Average riskdiff for cluster ' num2str(icluster) ' = ' num2str(funcaverage(thetadif(:,icluster)))...
        ' CI = (' num2str(tempsortthetadiff(round(itertemp*2.5/100))) ',' num2str(tempsortthetadiff(round(itertemp*97.5/100)))...
        '), No of subj.=' num2str(sum(clusterallocfinal==icluster)) '    ' gooddispphi{icluster}]);
    end
    if 1<tempsortthetaratio(round(itertemp*2.5/100)) 
    disp(['Average riskratio for cluster ' num2str(icluster) ' = ' num2str(funcaverage(thetaratio(:,icluster)))...
        ' CI = (' num2str(tempsortthetaratio(round(itertemp*2.5/100))) ',' num2str(tempsortthetaratio(round(itertemp*97.5/100)))...
        '), No of subj.=' num2str(sum(clusterallocfinal==icluster)) ' **>  ' gooddispphi{icluster}]);
    elseif 1>tempsortthetaratio(round(itertemp*97.5/100))
    disp(['Average riskratio for cluster ' num2str(icluster) ' = ' num2str(funcaverage(thetaratio(:,icluster)))...
        ' CI = (' num2str(tempsortthetaratio(round(itertemp*2.5/100))) ',' num2str(tempsortthetaratio(round(itertemp*97.5/100)))...
        '), No of subj.=' num2str(sum(clusterallocfinal==icluster)) ' **<  ' gooddispphi{icluster}]);
    else
    disp(['Average riskratio for cluster ' num2str(icluster) ' = ' num2str(funcaverage(thetaratio(:,icluster)))...
        ' CI = (' num2str(tempsortthetaratio(round(itertemp*2.5/100))) ',' num2str(tempsortthetaratio(round(itertemp*97.5/100)))...
        '), No of subj.=' num2str(sum(clusterallocfinal==icluster)) '    ' gooddispphi{icluster}]);
    end
    if 1<tempsortthetaoddsratio(round(itertemp*2.5/100)) 
    disp(['Average oddsratio for cluster ' num2str(icluster) ' = ' num2str(funcaverage(thetaoddsratio(:,icluster)))...
        ' CI = (' num2str(tempsortthetaoddsratio(round(itertemp*2.5/100))) ',' num2str(tempsortthetaoddsratio(round(itertemp*97.5/100)))...
        '), No of subj.=' num2str(sum(clusterallocfinal==icluster)) ' **>  ' gooddispphi{icluster}]);
    elseif 1>tempsortthetaoddsratio(round(itertemp*97.5/100))
    disp(['Average oddsratio for cluster ' num2str(icluster) ' = ' num2str(funcaverage(thetaoddsratio(:,icluster)))...
        ' CI = (' num2str(tempsortthetaoddsratio(round(itertemp*2.5/100))) ',' num2str(tempsortthetaoddsratio(round(itertemp*97.5/100)))...
        '), No of subj.=' num2str(sum(clusterallocfinal==icluster)) ' **<  ' gooddispphi{icluster}]);
    else
    disp(['Average oddsratio for cluster ' num2str(icluster) ' = ' num2str(funcaverage(thetaoddsratio(:,icluster)))...
        ' CI = (' num2str(tempsortthetaoddsratio(round(itertemp*2.5/100))) ',' num2str(tempsortthetaoddsratio(round(itertemp*97.5/100)))...
        '), No of subj.=' num2str(sum(clusterallocfinal==icluster)) '    ' gooddispphi{icluster}]);
    end
    end
end

disp(vectorofxt'); % for disp factor/phi info for each cluster
for icluster=1:maxnumofclustemp 
    if sum(clusterallocfinal==icluster)>1
        gooddispphi2{icluster}=['  ' gooddispphi{icluster}(1:nuoflevelst(1))];
        for idisp=1:size(nuoflevelst,2)-1
            gooddispphi2{icluster}=[gooddispphi2{icluster} '     ' gooddispphi{icluster}(sum(nuoflevelst(1:idisp))+1:sum(nuoflevelst(1:idisp+1)))];
        end
        disp(['Clust ' num2str(icluster) ' : ' gooddispphi2{icluster}]);
    end
end

% CREATE THE GRAPHS FOR THE VISUAL REPRESENTATION
for icluster=1:maxnumofclustemp 
if sum(clusterallocfinal==icluster)>1
figure(100+icluster)
markerforphidif=1;
selectfactorsforplot=ones(1,size(vectorofxt,2)); % to select factors for plotting
subplotindex=0;
for ifig=1:size(vectorofxt,2)
    CI=zeros(nuoflevelst(ifig),2);
    usecolor=zeros(1,nuoflevelst(ifig),3);
    fillmatrix1=zeros(nuoflevelst(ifig),4);
    fillmatrix2=zeros(nuoflevelst(ifig),4);
    if selectfactorsforplot(1,ifig)==1
        subplotindex=subplotindex+1;
        subplot(1,sum(selectfactorsforplot),subplotindex)
    end
for ilevel=1:nuoflevelst(ifig)
    tempsortphi=sort(phidif(:,markerforphidif,icluster)); % for the CI's
    CI(ilevel,1)=tempsortphi(round(itertemp*2.5/100));
    CI(ilevel,2)=tempsortphi(round(itertemp*97.5/100));
    if CI(ilevel,1)>0 
        usecolor(1,ilevel,1:3)=[1 0 0];  % red
    elseif CI(ilevel,2)<0 
        usecolor(1,ilevel,1:3)=[0 0 1];  % blue
    else
        usecolor(1,ilevel,1:3)=[0 1 0];  % green
    end
    markerforphidif=markerforphidif+1;
    fillmatrix1(ilevel,:)=[ilevel-0.3 ilevel+0.3 ilevel+0.3 ilevel-0.3];
    fillmatrix2(ilevel,:)=[CI(ilevel,1) CI(ilevel,1) CI(ilevel,2) CI(ilevel,2)];
end
if selectfactorsforplot(1,ifig)==1
    patch(fillmatrix1',fillmatrix2',usecolor); % better than fill
    axis([0 (nuoflevelst(ifig)+1) -1 1])
    line([0 (nuoflevelst(ifig)+1)],[0 0],'LineWidth',2,'Color','black','LineStyle','-')
    title(vectorofxt(ifig))
end
end
end
end